﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using TestServices.EdiPortalReceive;
using System.IO;

namespace TestServices
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            comboBoxFormatType.SelectedIndex = 0;
        }

        private void buttonFindFile_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                textBoxFile.Text = openFileDialog1.FileName;
            }
        }

        private void buttonSend_Click(object sender, EventArgs e)
        {
            textBoxOutput.Text = "Starting Send...";
            using (EdiPortalReceiveClient client = new EdiPortalReceiveClient("basicHttp"))
            {
                UserCredentials credentials = new UserCredentials { UserName = textBoxUsername.Text, Password = textBoxPassword.Text };
                FileInfo file = new FileInfo(textBoxFile.Text);
                InboxFile fileToSend = new InboxFile { FileName = file.Name, FileData = File.ReadAllBytes(file.FullName), IsZipped = false };

                try
                {
                    EdiPortalConfig ediPortalConfig = new EdiPortalConfig();
                    ediPortalConfig.DistributionObjectName = textBoxDON.Text;
                    ediPortalConfig.SenderEdiPortalId = textBoxSender.Text;
                    ediPortalConfig.ReceiverEdiPortalId = textBoxReceiver.Text;

                    AddToOutput("Calling service...");
                    client.SendFileToInbox(credentials, ediPortalConfig, fileToSend);
                    AddToOutput("File sent successfully!");
                }
                catch (Exception ex)
                {
                    AddToOutput("An error occurred:");
                    AddToOutput(String.Empty);
                    AddToOutput(ex.ToString());
                }
            }
        }

        private void AddToOutput(string text)
        {
            textBoxOutput.Text += text + Environment.NewLine;
        }
    }
}
